/*
 * CostumePanel.java
 *
 * Av JX^pl
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import java.util.Vector;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Graphics;

/**
 * CanvasgJX^plłB<br><br>
 * 
 * {NX́AeJX^pl̕iɑ΂Cxgs܂B<br>
 * Canvasp钊ۃNX̂߁A
 * AvCanvas̋@\̂܂܎gƂ\łB<br><br>
 * 
 * {@link CostumePanel#processEvent2(CComponent, int, int)} ɁA
 * Canvas#processEvent() ̃Cxgʒm܂B<br>
 * {@link CostumePanel#processEvent2(CComponent, int, int)}ɂ́A
 * PanellɁAR|[lg̃CxgA{@link CostumePanel#BUTTON_PRESSED}A
 * {@link CostumePanel#SELECTION_CHANGED}A
 * {@link CostumePanel#TEXT_CHANGED} ʒm܂B
 * ɂ́ACxgR|[lgIuWFNg܂B<br>
 * Cxgʒmɂ́A{@link #addEvent(CComponent)} ɂāA
 * CX^XR|[lg(i)o^ĂB
 * ɂtH[JXݒ肳AR|[lgIł悤ɂȂ܂B<br>
 * 
 * <pre>
 * yz
 * class Test extends CostumePanel {
 *
 *   CButton bt = new CButton("{^");
 * 
 *   public void paint(Graphics g) {
 *     g.lock();
 *     bt.show(g, 10, 10, true);
 *     addEvent(bt);
 *     g.unlock(true)
 *   }
 * 
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (c == bt && t == CostumePanel.BUTTON_PRESSED) {
 *       System.out.println("OK");
 *     }
 *   }
 * }
 * </pre>
 */
public abstract class CostumePanel extends Canvas {

    /**
     * {^ꂽɔsCxgł(={@value})B<br>
     * CCbuttontH[JXĂƂ
     * IL[ꂽꍇɔsCxgłB<br>
     */
    public static final int BUTTON_PRESSED = 100;

    /**
     * Xg̃ACȇIωɔsCxgł(={@value})B<br>
     * CPulldownList́ACCheckListtH[JXĂƂ
     * XgIƔsCxgłB<br>
     */
    public static final int SELECTION_CHANGED = 200;

    /**
     * eLXg͂̕m肵ƂɔsCxgł(={@value})B<br>
     * CTextBoxtH[JXĂƂ
     * eLXg͂m肷ƔsCxgłB<br>
     */
    public static final int TEXT_CHANGED = 300;

    /**
     * IME ON ̏ꍇɔsCxgł(={@value})B<br>
     * CTextBox̃CxgɂĈĂ܂B<br>
     */
    static final int TEXT_IMEON = 400;
    
    /**
     * JX^pl𐶐܂B
     */
    public CostumePanel() { }

    /**
     * 쐬R|[lgCxgXi[ɓo^܂B<br>
     * 
     * ǉꂽR|[lg̏ԂɃtH[JXA[̃CxgA
     * tH[JXĂR|[lgɑ΂CxgƂĒʒm܂B
     * tH[JXȂ(IȂ)ꍇA܂́A
     * tH[JX̖R|[lg(CLabelACBulletinBoard)͓o^svłB<br>
     * łɓo^ς݂̓IuWFNg̏ꍇ͓o^܂񂪁A
     * IꂽĩtH[JXĕ`悵܂B<br>
     * 
     * @param comp o^R|[lgw肵܂B
     */
    public void addEvent(CComponent comp) {
        int index;
        // R|[lgo^ς݂ǂ
        if ((index = components.indexOf(comp)) == -1) {
            index = components.size();       // ŏ
            // R|[lg̒ǉ
            components.addElement(comp);
        }

        // IꂽR|[lg̏ꍇAtH[JX(񁕍ĕ`)
        if (focusNum == index) {
            ((CComponent)components.elementAt(focusNum)).setFocus();
        }
    }

    /**
     * w̃R|[lgɃtH[JXݒ肵܂B<br>
     * addEvent() œo^ꂽîݗLłB<br>
     * 
     * @param comp tH[JXݒ肷R|[lgw肵܂B
     */
    public void setFocus(CComponent comp) {
        int num;
        // R|[lgo^ς݂ǂ
        if ((num = components.indexOf(comp)) != -1) {
            // ݂̃tH[JXNA
            ((CComponent)components.elementAt(focusNum)).resetFocus();
            // w̃R|[lgɃtH[JX
            comp.setFocus();
            focusNum = num;
        }
    }
        
    /**
     * CxgʒmꂽɌĂ΂鏈łB<br>
     * 
     * TuNXŖ{\bhI[o[Ch鎖͂ł܂B
     * {\bh̑ƂāA
     * CustumePanel#{@link #processEvent2(CComponent, int, int)} 𗘗pĂB
     * 
     * @param t Cxg̃^Cvw肵܂B
     * @param p Cxg̃p[^w肵܂B
     */
    public final void processEvent(int t,
                                   int p) {
        CComponent c  = null;

        if (components.size() != 0) {
            // ݑIĂ镔i
            c = (CComponent)components.elementAt(focusNum);
            if (t == Display.KEY_RELEASED_EVENT) {
                if (p == Display.KEY_SELECT) {
                    // iIANVs
                    int s = c.actionSelect();
                    // IMECxg̏ꍇ
                    if (s == TEXT_IMEON) {
                        c.imeOn(this, null);
                    }
                    else if (s != -1) {
                        // ĩCxg̓Cxg^CvύX
                        t = s;
                    }
                }
                // / L[
                if ((p == Display.KEY_LEFT || p == Display.KEY_UP)) {
                    // iړANV
                    if (c.actionPosition(-1)) {
                        // ĩCxgꍇ͉Ȃ
                        return;
                    }

                    /*
                     * O̕iɃtH[JXړ
                     */
                    // tH[JXNA
                    c.resetFocus();
                    // ÕR|[lg
                    focusNum = (focusNum-1 > 0 ? focusNum-1 : 0);
                    c = (CComponent)components.elementAt(focusNum);
                    // tH[JXݒ
                    c.setFocus();
                }
                // E/ L[
                else if ((p == Display.KEY_RIGHT || p == Display.KEY_DOWN)) {
                    // iړANV
                    if (c.actionPosition(+1)) {
                        // ĩCxgꍇ͉Ȃ
                        return;
                    }

                    /*
                     * ̕iɃtH[JXړ
                     */
                    // tH[JXNA
                    c.resetFocus();
                    // ̃R|[lg
                    focusNum = (focusNum+1 < components.size() ? focusNum+1 : focusNum);
                    c = (CComponent)components.elementAt(focusNum);
                    // tH[JXݒ
                    c.setFocus();
                }
            }
        }

        // processEvent2()֒ʒm
        processEvent2(c, t, p);
    }
    
    /**
     * IMECxgʒmꂽƂɌĂ΂郁\bhłB<br>
     * 
     * @param type Cxg̃^Cvn܂B
     * @param text ͂ꂽ񂪓n܂B
     */
    public final void processIMEEvent(int    type,
                                      String text) {
        // IMECxg̏ꍇ
        ((CComponent)components.elementAt(focusNum)).imeOn(null, text);
        // TEXT_CHANGEDCxg
        processEvent(TEXT_CHANGED, Display.KEY_SELECT);
    }

    /**
     * LoXɕ\邽߂Ɏgp郁\bhłB<br>
     * ̃\bh́ALoX\^C~OŌĂяo܂B<br>
     * 
     * @param g OtBbNXIuWFNgn܂B
     */
    public abstract void paint(Graphics g);
    
    /**
     * CxgʒmꂽɌĂ΂鏈łB<br>
     * 
     * TuNX Canvas#processEvent() ̑ɗp܂B
     * 
     * @param c ݑI𒆂̕iIuWFNgn܂B
     * @param t Cxg̃^Cvn܂B
     * @param p Cxg̃p[^n܂B
     */
    public void processEvent2(CComponent c, int t, int p) { }
    
    /*
     * `
     */
    private Vector  components = new Vector(); // o^R|[lg
    private int     focusNum   = 0;            // IꂽR|[lg̔zԍ
}
