/*
 * CTextBox.java
 *
 * AvJX^pl eLXg{bNX
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.TextBox;

/**
 * Canvasɕ`悷eLXg{bNXłB<br>
 *
 * <pre>
 * yz
 * class Test extends CostumePanel {
 *   CTextBox tx  = new CTextBox("TEXT", 10, 10);
 *
 *   public void paint(Graphics g) {
 * 
 *     tx.show(g, 10, 10, true);
 *     addEvent(tx);
 *         F
 *   }
 * }
 * </pre>
 */
public final class CTextBox extends iappli.lib.ui.CComponent {

    /**
     * eLXg{bNX𐶐܂B<br>
     */
    public CTextBox() {
        this(null, 10, 0);
    }

    /**
     * eLXgw肵ăeLXg{bNX𐶐܂B<br>
     *
     * @param text      eLXg{bNX̃eLXgw肵܂B
     * @param columns   w肵܂B́ApŐ܂B
     * @param inputSize ͕̐lOȏŎw肵܂B
     *                   ȌꍇA͐͂܂B
     */
    public CTextBox(String text,
                    int columns,
                    int inputSize) {

        if (text == null) {
            text = "";
        }
        this.text      = text;
        this.columns   = columns;
        this.inputSize = inputSize;
    }

    /**
     * eLXgAOiFAetFw肵ăeLXg{bNX𐶐܂B<br>
     *
     * @param text      eLXgw肵܂B
     * @param columns   w肵܂B́ApŐ܂B
     * @param inputSize ͕̐lOȏŎw肵܂B 
     *                   ȌꍇA͐͂܂B
     * @param c1        OiFw肵܂B
     * @param c2        wiFw肵܂B
     * @param s         etFw肵܂B
     */
    public CTextBox(String  text,
                    int     columns,
                    int     inputSize,
                    int     c1,
                    int     c2,
                    int     s)
    {
        this(text, columns, inputSize);

        super.fgcolor = c1;
        super.bgcolor = c2;
        super.setShadow(s);
    }

    /**
     * eLXgݒ肵܂B<br>
     *
     * @param text eLXgw肵܂B
     *              null w肳ꂽꍇ͋󕶎("")ݒ肳܂B
     */
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    /**
     * eLXg擾܂B<br>
     *
     * @return eLXg{bNX̃eLXgԂ܂B
     */
    public String getText() {
        return this.text;
    }
    
    /**
     * eLXgɓ͉\ȕ𐧌܂B<br>
     * 
     * ftHgł͖ɐݒ肳Ă܂B<br>
     * 
     * @param inputSize ͕̐lOȏŎw肵܂BȌꍇAȂB
     */
    public void setInputSize(int inputSize) {
        this.inputSize = inputSize;
    }

    /**
     * eLXg̏̓[hݒ肵܂B<br>
     * 
     * TextBox#ALPHA, TextBox#NUMBER, TextBox#KANA ̂ꂩw肵܂B<br>
     * ftHǵATextBox#NUMBER łB
     * 
     * @param mode ̓[hw肵܂B
     *         ݒ肷ĺACanvas{@link #setInputMode(int)}ɏ܂B
     */
    public void setInputMode(int mode) {
        this.inputMode = mode;
    }

    /**
     * eLXg{bNX`悵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock s܂B
     * ĂяoɂĎsĂB
     *
     * @param g LpX̃OtBbNXIuWFNg(this.getGraphics())w肵܂B
     * @param x W()w肵܂B
     * @param y cW()w肵܂B
     * @param b truew肷ƕ`OobNAbv܂B
     *           (q[v邽ߎgȂꍇ false w肵ĂB)
     */
    public void show(Graphics g, int x, int y, boolean b) {
        
        // `ς݂폜
        clear();

        // 擾
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c

        // X,Y W𕶎Ŏw
        x = x * fw;
        y = y * fh;

        synchronized (this) {
            // ޔ
            super.x = x;
            super.y = y;
            super.w  = fw * columns + 1;
            super.h = fh + 1;
            super.backup = b;
            super.g = g;
        }
        
        // obNAbvL̏ꍇACanvas̉摜ޔ
        super.backupImage();

        /*
         * eLXg{bNX`
         */
        // wi
        g.setColor(super.bgcolor);
        g.fillRect(x, y, w, h);
        int pd[] = g.getRGBPixels(x, y, w, h, null, 0);
        textArea = Image.createImage(w, h, pd, 0);

        // A̘g
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.drawLine(x-1, y-1, x+w, y-1);        // 
        g.drawLine(x-1, y-1, x-1, y+h);        // 
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x-2, y-2, x+w+1, y-2);      // 
        g.drawLine(x-2, y-2, x-2, y+h+1);      // 

        // AE̘g
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x-1, y+h, x+w, y+h);        // 
        g.drawLine(x+w, y-1, x+w, y+h);        // E
        g.setColor(Graphics.getColorOfRGB(240, 240, 240));
        g.drawLine(x-2, y+h+1, x+w+1, y+h+1);  // 
        g.drawLine(x+w+1, y-2, x+w+1, y+h+1);  // E

        // eLXg\
        writeText();
    }
    
    /**
     * eLXg`悵܂B<br>
     */
    protected void writeText() {
        // 擾
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // eLXg`̈̃NA
        super.g.drawImage(textArea, super.x, super.y);

        // eLXg` (`̈敪̂ݕ\)
        int px = x;
        for (int i = 0; i < text.length(); i++) {
            if (text.substring(i, i+1).equals("\n") || (px+fw*2 > x+w)) {
                break;
            }
            if (super.sdflag) {
                // eLXg̉et`
                super.g.setColor(super.sdcolor);
                super.g.drawString(text.substring(i, i+1), px+2, super.y+fh+bl-1);
            }

            // eLXg`
            super.g.setColor(super.fgcolor);
            super.g.drawString(text.substring(i, i+1), px+1, super.y+fh+bl-2);
            px += text.substring(i, i+1).getBytes().length*fw;
        }
    }

    /**
     * tH[JXݒ肵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void setFocus() {
        // obNobt@ɃtH[JXỎ摜obNAbv
        int pd[] = g.getRGBPixels(super.x-5, super.y-5, super.w+10,
                                  super.h+10, null, 0);
        imf = Image.createImage(super.w+10, super.h+10, pd, 0);

        // tH[JX`
        super.g.lock();
        super.g.setColor(Graphics.getColorOfName(Graphics.BLUE));
        super.g.drawRect(super.x-5, super.y-5, super.w+9, super.h+9);
        super.g.drawRect(super.x-4, super.y-4, super.w+7, super.h+7);
        super.g.unlock(true);
    }
    
    /**
     * tH[JX폜܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void resetFocus() {
        // tH[JXÕobNobt@`
        super.g.drawImage(imf, super.x-5, super.y-5);
        writeText();
        imf = null;
    }

    /**
     * hlds܂B<br>
     * IMEN[Yɂs܂B
     * ̏ꍇAP̃LpXnullŎsĂB
     * 
     * @param c IMEsLpXw肵܂B
     * @param text IMEN[YꂽIME̓ew肵܂B
     */
    protected void imeOn(Canvas c, String text) {
        // IME OFF
        if (c == null) {
            this.text = text;
            writeText();
        }
        // IME ON
        else {
            if (inputSize > 0) {
                // TCY
                c.imeOn(getText(),
                       TextBox.DISPLAY_ANY,
                       inputMode,
                       inputSize);
            }
            else {
                // TCYȂ
                c.imeOn(getText(),
                       TextBox.DISPLAY_ANY,
                       inputMode);
            }
        }
    }

    /**
     * iIANVs܂B<br>
     * @return Cxg̃^CvԂ܂B
     */
    protected int actionSelect() {
        return CostumePanel.TEXT_IMEON;
    }

    /**
     * ړANVs܂B<br>
     * @param num ANVԍn܂B-1:O 1:
     * @return  false Ԃ܂B
     */
    protected boolean actionPosition(int num) { return false; }

    /*
     * `
     */
    private int     columns   = 1;      // eLXg{bNX JTCY
    private int     inputMode = 0;      // ̓[h l͐l
    private int     inputSize = 0;      // ͐
    private String  text = "";          // x
    private Image   imf  = null;        // tH[JXO摜
    private Image   textArea = null;    // eLXg\̈̉摜
}
