/*
 * CComponent.java
 *
 * AvJX^pl ʕi`
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Font;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;

/**
 * i`܂B<br>
 */
public abstract class CComponent {

    /**
     * AvP[Vڂ̃NX̃CX^X𐶐邱Ƃ͂ł܂B <br>
     */
    public CComponent() { }

    /**
     * i̔wiFݒ肵܂B<br>
     * 
     * ftHǵAGraphics.WHITE łB<br>
     * ߂ꍇ́AGraphics.getColorOfRGB(255, 255, 255, 0) w肵ĂB
     * 
     * @param c wiFw肵܂B
     */
    public void setBackground(int c) {
        bgcolor = c;
    }

    /**
     * ȋOiFݒ肵܂B<br>
     * 
     * ftHǵAGraphics.BLACK łB
     * 
     * @param c OiFw肵܂B
     */
    public void setForeground(int c) {
        fgcolor = c;
    }
    
    /**
     * iɕ\镶̉etFݒ肵܂B <br>
     * 
     * ftHg͉ełB<br>
     * {\bhňxݒ肷ƕKetɂȂ܂B
     * 
     * @param c etFw肵܂B
     */
    public void setShadow(int c) {
        sdcolor = c;
        sdflag = true;
    }

    /**
     * ĩtHgݒ肵܂B<br>
     */
    public void setFont(Font f) {
        this.f = f;
    }
    
    /**
     * ïʒuݒ肵܂B<br>
     * 
     * @param x i X W()w肵܂B
     * @param y i Y W()w肵܂B
     */
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    /**
     * ĩTCYݒ肵܂B<br>
     * 
     * @param w ỉ()w肵܂B
     * @param h ȉc()w肵܂B
     */
    public void setSize(int w, int h) {
        this.w  = w;
        this.h = h;
    }

    /**
     * wi摜̃obNAbvLݒ肵܂B<br>
     * 
     * obNAbv́AR|[lg̕\\bhŎs܂B<br>
     * ̂߁A{\bh́AR|[lg̕\Oɐݒ肵ĂB<br>
     *
     * @param b obNAbvLw肵܂B
     */
    public void setBackup(boolean b) {
        this.backup = b;
    }

    /**
     * `悷LpXݒ肵܂B<br>
     * 
     * @param g LpX̃OtBNXIuWFNgw肵܂B(this.getGraphics())
     */
    public void setGraphics(Graphics g) {
        this.g = g;
    }

    /**
     * `悵i܂B<br>
     * 
     * {\bhsACanvas#repaint() sƏ܂B<br>
     * ܂AobNAbvꂽwi摜͔j܂B<br><br>
     * 
     * ̃\bh́AobNAbv true Ɏw肵ꍇɗLłB<br>
     * obNAbvꂽwi摜ȂꍇA
     * ̃\bhsĂ܂B<br>
     * ܂`悵iɏdȂĂ镔iĂ܂܂̂ŁA
     * i鏇ԂɂӂB<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B<br>
     */
    public void clear() {
        // obNobt@݂Ȃꍇ͉ȂB
        if (im != null) {
            // obNobt@`
            g.lock();
            g.drawImage(im, x, y);
            g.unlock(true);
            im = null;
        }
    }
    
    /**
     * `悷镔i̔wi摜obNAbv܂B<br>
     * 
     * (x, y)̈ʒuA(x+width,y+height)̈ʒu܂ł̉摜obNAbv܂B<br>
     * ̃\bh́AobNAbv true Ɏw肵ꍇɗLłB<br>
     * {\bh́Ai`悷OɎsĂB<br>
     */
    void backupImage() {
        if (!backup) {
            return;
        }
        // obNobt@ɉ摜obNAbv
        int pd[] = g.getRGBPixels(x, y, w, h, null, 0);
        im = Image.createImage(w, h, pd, 0);
    }

    /**
     * tH[JXݒ肷郁\bhłB<br>
     * tH[JXiɂĂ͉ȂłB<br>
     */
    protected abstract void setFocus();
    
    /**
     * tH[JX폜郁\bhłB<br>
     * tH[JXiɂĂ͉ȂłB<br>
     */
    protected abstract void resetFocus();

    /**
     * ȋIANV`܂B<br>
     * eiɂđIL[őIꍇɎs܂B
     * 
     * @return Cxg̃^CvԂ܂BCxgɕύXꍇ́A-1 ԂĂB
     */
    protected abstract int actionSelect();

    /**
     * ïړANV`܂B<br>
     * eiɂď㉺EL[ňړꍇɎs܂B
     * 
     * @param num -1:/ L[(O) +1:E/ L[() w肵܂B
     * @return ANV̏ꍇ́Atrue ԂĂBtrue ԂƂ̌̏s܂B
     */
    protected abstract boolean actionPosition(int num);

    /**
     * hlds܂B<br>
     * hldíA{\bhI[oChĂB<br>
     * IMEN[Yɂs܂B
     * ̏ꍇAP̃LpXnullŎsĂB<br>
     * 
     * @param c IMEsLpXw肵܂B
     * @param text IMEN[YꂽIME̓ew肵܂B
     */
    protected void imeOn(Canvas c, String text) { }
    
    /*
     * i(R|[lg)l
     */
    Graphics g  = null;              // `悷LpX

    int x       = 0;                 // `JnwW
    int y       = 0;                 // `JnxW
    int w       = 0;                 // `扡
    int h       = 0;                 // `c
    int bgcolor = Graphics.getColorOfName(Graphics.WHITE); // wiF
    int fgcolor = Graphics.getColorOfName(Graphics.BLACK); // OiF
    boolean sdflag = false;          // etL
    int sdcolor = Graphics.getColorOfName(Graphics.WHITE); // etF
    boolean backup = false;          // wi摜obNAbvL
    Image   im  = null;              // wi摜
    Font f = Font.getDefaultFont();  // tHg
}
